﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

namespace Hilscher.CifX
{
    public class CifxDevDrv
    {
        #region Structure definitions
        /// <exclude/>
        /* System Channel: System Information Block */
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct SYSTEM_CHANNEL_SYSTEM_INFO_BLOCKtag
        {
            /// <exclude/>
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 4)]
            public byte[] abCookie;                                   /*!< 0x00 "netX" cookie */
            /// <exclude/>
            public ulong ulDpmTotalSize;                                /*!< 0x04 Total Size of the whole dual-port memory in bytes */
            /// <exclude/>
            public ulong ulDeviceNumber;                                /*!< 0x08 Device number */
            /// <exclude/>
            public ulong ulSerialNumber;                                /*!< 0x0C Serial number */
            /// <exclude/>
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 4)]
            public ushort[] ausHwOptions;                               /*!< 0x10 Hardware options, xC port 0..3 */
            /// <exclude/>
            public ushort usManufacturer;                                /*!< 0x18 Manufacturer Location */
            /// <exclude/>
            public ushort usProductionDate;                              /*!< 0x1A Date of production */
            /// <exclude/>
            public ulong ulLicenseFlags1;                               /*!< 0x1C License code flags 1 */
            /// <exclude/>
            public long ulLicenseFlags2;                               /*!< 0x20 License code flags 2 */
            /// <exclude/>
            public ushort usNetxLicenseID;                               /*!< 0x24 netX license identification */
            /// <exclude/>
            public ushort usNetxLicenseFlags;                            /*!< 0x26 netX license flags */
            /// <exclude/>
            public ushort usDeviceClass;                                 /*!< 0x28 netX device class */
            /// <exclude/>
            public char bHwRevision;                                   /*!< 0x2A Hardware revision index */
            /// <exclude/>
            public char bHwCompatibility;                              /*!< 0x2B Hardware compatibility index */
            /// <exclude/>
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 2)]
            public short[] ausReserved;                                /*!< 0x2C:0x2F Reserved */
        }

        /// <exclude/>
        private const int NXDRV_NAME_LENGTH = 64;
        /// <exclude/>
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct NXDRV_DEVICE_INFORMATIONtag
        {
            /// <exclude/>
            public UInt32 hDevice;                        //!< Device handle
            /// <exclude/>
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = NXDRV_NAME_LENGTH)]
            public byte[] szDeviceName;//!< Device name
            /// <exclude/>
            public SYSTEM_CHANNEL_SYSTEM_INFO_BLOCKtag tSystemInfoBlock;               //!< Device System Info Block
        }

        /// <exclude/>
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct DRIVER_INFORMATIONtag
        {
            /// <exclude/>
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
            public byte[] abDriverVersion;                              /*!< Driver version                 */
            /// <exclude/>
            public UInt32 ulBoardCnt;                                   /*!< Number of available Boards     */
        }
        /// <exclude/>
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct SYSTEM_CHANNEL_INFORMATIONtag                     /*! System Channel Information structure*/
        {
            /// <exclude/>
            public UInt32 ulSystemError;                                /*!< Global system error            */
            /// <exclude/>
            public UInt32 ulDpmTotalSize;                               /*!< Total size dual-port memory in bytes */
            /// <exclude/>
            public UInt32 ulMBXSize;                                    /*!< System mailbox data size [Byte]*/
            /// <exclude/>
            public UInt32 ulDeviceNumber;                               /*!< Global device number           */
            /// <exclude/>
            public UInt32 ulSerialNumber;                               /*!< Global serial number           */
            /// <exclude/>
            public UInt32 ulOpenCnt;                                    /*!< Channel open counter           */
        }
        public UInt32 CIFx_MAX_INFO_NAME_LENGTH = 8;
        /// <exclude/>
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct CIFX_DIRECTORYENTRYtag                    /*! Directory Information structure for enumerating directories */
        {
            /// <exclude/>
            public UInt32 hList;                                /*!< Handle from Enumeration function, do not touch */
            /// <exclude/>
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
            public byte[] szFilename;                           /*!< Returned file name. */
            /// <exclude/>
            public byte bFiletype;                            /*!< Returned file type. */
            /// <exclude/>
            public UInt32 ulFilesize;                           /*!< Returned file size. */
        }
        /// <exclude/>
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct SYSTEM_CHANNEL_INFO_BLOCKtag                         /* System Channel: System Information Block */
        {
            /// <exclude/>
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 4)]
            public byte[] abCookie;                                      /*!< 0x00 "netX" cookie */
            /// <exclude/>
            public UInt32 ulDpmTotalSize;                                /*!< 0x04 Total Size of the whole dual-port memory in bytes */
            /// <exclude/>
            public UInt32 ulDeviceNumber;                                /*!< 0x08 Device number */
            /// <exclude/>
            public UInt32 ulSerialNumber;                                /*!< 0x0C Serial number */
            /// <exclude/>
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 4)]
            public UInt16[] ausHwOptions;                                  /*!< 0x10 Hardware options, xC port 0..3 */
            /// <exclude/>
            public UInt16 usManufacturer;                                /*!< 0x18 Manufacturer Location */
            /// <exclude/>
            public UInt16 usProductionDate;                              /*!< 0x1A Date of production */
            /// <exclude/>
            public UInt32 ulLicenseFlags1;                               /*!< 0x1C License code flags 1 */
            /// <exclude/>
            public UInt32 ulLicenseFlags2;                               /*!< 0x20 License code flags 2 */
            /// <exclude/>
            public UInt16 usNetxLicenseID;                               /*!< 0x24 netX license identification */
            /// <exclude/>
            public UInt16 usNetxLicenseFlags;                            /*!< 0x26 netX license flags */
            /// <exclude/>
            public UInt16 usDeviceClass;                                 /*!< 0x28 netX device class */
            /// <exclude/>
            public byte bHwRevision;                                   /*!< 0x2A Hardware revision index */
            /// <exclude/>
            public byte bHwCompatibility;                              /*!< 0x2B Hardware compatibility index */
            /// <exclude/>
            public byte bDevIdNumber;                                  /*!< Device Identification number (rotary switch) */
            /// <exclude/>
            public byte bReserved;                                     /*!< unused/reserved */
            /// <exclude/>
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 2)]
            public UInt16[] ausReserved;                                   /*!< 0x2C:0x2F Reserved */
        }

        /// <exclude/>
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct SYSTEM_CHANNEL_SYSTEM_CONTROL_BLOCKtag             /* System Channel: System Control Block */
        {
            /// <exclude/>
            public UInt32 ulSystemCommandCOS;                            /*!< 0x00 System channel change of state command */
            /// <exclude/>
            public UInt32 ulReserved;                                    /*!< 0x04 Reserved */
        }
        /// <exclude/>
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct SYSTEM_CHANNEL_SYSTEM_STATUS_BLOCKtag              /* System Channel: System Status Block */
        {
            /// <exclude/>
            public UInt32 ulSystemCOS;                                   /*!< 0x00 System channel change of state acknowledge */
            /// <exclude/>
            public UInt32 ulSystemStatus;                                /*!< 0x04 Actual system state */
            /// <exclude/>
            public UInt32 ulSystemError;                                 /*!< 0x08 Actual system error */
            /// <exclude/>
            public UInt32 ulBootError;                                   /*!< 0x0C Bootup error code (only valid if Cookie="BOOT") */
            /// <exclude/>
            public UInt32 ulTimeSinceStart;                              /*!< 0x10 time since start in seconds */
            /// <exclude/>
            public UInt16 usCpuLoad;                                     /*!< 0x14 cpu load in 0,01% units (10000 => 100%) */
            /// <exclude/>
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 42)]
            public byte[] abReserved;                                    /*!< 0x16:3F Reserved */
        }
        /// <exclude/>
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct BOARD_INFORMATIONtag                            /*! Board Information structure                                              */
        {
            /// <exclude/>
            public UInt32 lBoardError;                                /*!< Global Board error. Set when device specific data must not be used */
            /// <exclude/>
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = CIFx_MAX_INFO_NAME_LENTH)]
            public byte[] abBoardName;                                /*!< Global board name              */
            /// <exclude/>
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = CIFx_MAX_INFO_NAME_LENTH)]
            public byte[] abBoardAlias;                               /*!< Global board alias name        */
            /// <exclude/>
            public UInt32 ulBoardID;                                  /*!< Unique board ID, driver created*/
            /// <exclude/>
            public UInt32 ulSystemError;                              /*!< System error                   */
            /// <exclude/>
            public UInt32 ulPhysicalAddress;                          /*!< Physical memory address        */
            /// <exclude/>
            public UInt32 ulIrqNumber;                                /*!< Hardware interrupt number      */
            /// <exclude/>
            public byte bIrqEnabled;                                /*!< Hardware interrupt enable flag */
            /// <exclude/>
            public UInt32 ulChannelCnt;                               /*!< Number of available channels   */
            /// <exclude/>
            public UInt32 ulDpmTotalSize;                             /*!< Dual-Port memory size in bytes */
            /// <exclude/>
            public SYSTEM_CHANNEL_INFO_BLOCKtag tSystemInfo;          /*!< System information             */
        }
        /// <exclude/>
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct CHANNEL_INFORMATIONtag                            /*! Channel Information structure                                            */
        {
            /// <exclude/>
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = CIFx_MAX_INFO_NAME_LENTH)]
            public byte[] abBoardName;                                  /*!< Global board name              */
            /// <exclude/>
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = CIFx_MAX_INFO_NAME_LENTH)]
            public byte[] abBoardAlias;                                 /*!< Global board alias name        */
            /// <exclude/>
            public UInt32 ulDeviceNumber;                               /*!< Global board device number     */
            /// <exclude/>
            public UInt32 ulSerialNumber;                               /*!< Global board serial number     */
            /// <exclude/>
            public UInt16 usFWMajor;                                    /*!< Major Version of Channel Firmware  */
            /// <exclude/>
            public UInt16 usFWMinor;                                    /*!< Minor Version of Channel Firmware  */
            /// <exclude/>
            public UInt16 usFWBuild;                                    /*!< Build number of Channel Firmware   */
            /// <exclude/>
            public UInt16 usFWRevision;                                 /*!< Revision of Channel Firmware       */
            /// <exclude/>
            public byte bFWNameLength;                                /*!< Length  of FW Name                 */
            /// <exclude/>
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 63)]
            public byte[] abFWName;                                     /*!< Firmware Name                      */
            /// <exclude/>
            public UInt16 usFWYear;                                     /*!< Build Year of Firmware             */
            /// <exclude/>
            public byte bFWMonth;                                     /*!< Build Month of Firmware (1..12)    */
            /// <exclude/>
            public byte bFWDay;                                       /*!< Build Day of Firmware (1..31)      */
            /// <exclude/>
            public UInt32 ulChannelError;                               /*!< Channel error                  */
            /// <exclude/>
            public UInt32 ulOpenCnt;                                    /*!< Channel open counter           */
            /// <exclude/>
            public UInt32 ulPutPacketCnt;                               /*!< Number of put packet commands  */
            /// <exclude/>
            public UInt32 ulGetPacketCnt;                               /*!< Number of get packet commands  */
            /// <exclude/>
            public UInt32 ulMailboxSize;                                /*!< Mailbox packet size in bytes   */
            /// <exclude/>
            public UInt32 ulIOInAreaCnt;                                /*!< Number of IO IN areas          */
            /// <exclude/>
            public UInt32 ulIOOutAreaCnt;                               /*!< Number of IO OUT areas         */
            /// <exclude/>
            public UInt32 ulHskSize;                                    /*!< Size of the handshake cells    */
            /// <exclude/>
            public UInt32 ulNetxFlags;                                  /*!< Actual netX state flags        */
            /// <exclude/>
            public UInt32 ulHostFlags;                                  /*!< Actual Host flags              */
            /// <exclude/>
            public UInt32 ulHostCOSFlags;                               /*!< Actual Host COS flags          */
            /// <exclude/>
            public UInt32 ulDeviceCOSFlags;                             /*!< Actual Device COS flags        */
        }
        /// <exclude/>
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct CHANNEL_IO_INFORMATIONtag         /*! IO Area Information structure                                            */
        {
            /// <exclude/>
            public UInt32 ulTotalSize;                  /*!< Total IO area size in byte */
            /// <exclude/>
            public UInt32 ulUsedSize;                   /*!< Used IO area size in byte */
            /// <exclude/>
            public UInt32 ulIOMode;                     /*!< Exchange mode */
        }
        /// <exclude/>
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public unsafe struct MEMORY_INFORMATION         /*! Memory Information structure                                             */
        {
            /// <exclude/>
            [MarshalAs(UnmanagedType.LPArray, SizeConst = 1)]
            public UInt32 pvMemoryID;                  /*!< Identification of the memory area      */
            /// <exclude/>
            public UInt32* ppvMemoryPtr;                /*!< Memory pointer                         */
            /// <exclude/>
            public UInt32* pulMemorySize;               /*!< Complete size of the mapped memory     */
            /// <exclude/>
            public UInt32 ulChannel;                   /*!< Requested channel number               */
            /// <exclude/>
            public UInt32* pulChannelStartOffset;       /*!< Start offset of the requested channel  */
            /// <exclude/>
            public UInt32* pulChannelSize;              /*!< Memory size of the requested channel   */
        }
        /// <exclude/>
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public unsafe struct PLC_MEMORY_INFORMATIONtag          /*! PLC Memory Information structure */
        {
            /// <exclude/>
            void* pvMemoryID;           /*!< Identification of the memory area */
            /// <exclude/>
            void** ppvMemoryPtr;         /*!< Memory pointer                   */
            /// <exclude/>
            UInt32 ulAreaDefinition;     /*!< Input/output area                  */
            /// <exclude/>
            UInt32 ulAreaNumber;         /*!< Area number                        */
            /// <exclude/>
            UInt32* pulIOAreaStartOffset; /*!< Start offset                       */
            /// <exclude/>
            UInt32* pulIOAreaSize;        /*!< Memory size                        */
        }

        /// <exclude/>
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct CIFX_PACKET_HEADERtag     /*! Packet header     */
        {
            /// <exclude/>
            public UInt32 ulDest;   /*!< destination of packet, process queue */
            /// <exclude/>
            public UInt32 ulSrc;    /*!< source of packet, process queue */
            /// <exclude/>
            public UInt32 ulDestId; /*!< destination reference of packet */
            /// <exclude/>
            public UInt32 ulSrcId;  /*!< source reference of packet */
            /// <exclude/>
            public UInt32 ulLen;    /*!< length of packet data without header */
            /// <exclude/>
            public UInt32 ulId;     /*!< identification handle of sender */
            /// <exclude/>
            public UInt32 ulState;  /*!< status code of operation */
            /// <exclude/>
            public UInt32 ulCmd;    /*!< packet command defined in TLR_Commands.h */
            /// <exclude/>
            public UInt32 ulExt;    /*!< extension */
            /// <exclude/>
            public UInt32 ulRout;   /*!< router */
        }
        /// <exclude/>
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct CIFX_PACKETtag            /*! Definition of the rcX Packet                                             */
        {
            /// <exclude/>
            public CIFX_PACKET_HEADERtag tHeader;                   /**! */
            /// <exclude/>
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = CIFX_MAX_DATA_SIZE)]
            public byte[] abData;
        }
        /// <exclude/>
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct PFN_PROGRESS_CALLBACK
        {
            /// <exclude/>
            UInt32 ulStep;
            /// <exclude/>
            UInt32 ulMaxStep;
            /// <exclude/>
            UInt32 pvUser;
            /// <exclude/>
            char bFinished;
            /// <exclude/>
            long lError;
        }
        /// <exclude/>
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct PFN_RECV_PKT_CALLBACK
        {
            /// <exclude/>
            [MarshalAs(UnmanagedType.U4)]
            CIFX_PACKETtag ptRecvPkt;
            /// <exclude/>
            UInt32 pvUser;
        }
        //typedef void(*PFN_PROGRESS_CALLBACK)(unsigned long ulStep, unsigned long ulMaxStep, void* pvUser, char bFinished, long lError);
        //typedef void(*PFN_RECV_PKT_CALLBACK)(CIFX_PACKET* ptRecvPkt, void* pvUser);

        #endregion

        #region API Calls
        [DllImport("cifx32dll.dll", EntryPoint = "nxDrvInit")]
        private static extern UInt32 _nxDrvInit();

        [DllImport("cifX32dll.dll", EntryPoint = "nxDrvFindDevice")]
        private static extern UInt32 _nxDrvFindDevice(UInt32 uiCommand,
                                                        UInt32 uiSize,
                                                        ref NXDRV_DEVICE_INFORMATIONtag tDeviceInfo,
                                                        ref UInt32 uiSearchIndex);

        [DllImport("cifX32dll.dll", EntryPoint = "nxDrvDownload")]
        private static extern UInt32 _nxDrvDownload(UInt32 hDevice, UInt32 ulChannel, UInt32 ulMode,
                                                    UInt32 ulFileSize,
                                                    [MarshalAs(UnmanagedType.LPStr)] string sFileName,
                                                    Byte[] pabFileData,
                                                    UInt32 pvUser,
                                                    string PFN1);

        [DllImport("cifX32dll.dll", EntryPoint = "nxDrvStart")]
        private static extern UInt32 _nxDrvStart(UInt32 uihDevice, UInt32 uiChannel);

        [DllImport("cifx32dll.dll", EntryPoint = "xDriverGetInformation")]
        private static extern UInt32 _xDriverGetInformation(UInt32 CIFXHANDLE,
                                                                UInt32 ulSize,
                                                                ref DRIVER_INFORMATIONtag pvDriverInfo);

        [DllImport("cifx32dll.dll", EntryPoint = "xDriverOpen")]
        private static extern UInt32 _xDriverOpen([MarshalAs(UnmanagedType.U4)]
                                                     ref UInt32 CIFXHANDLE);

        [DllImport("cifx32dll.dll", EntryPoint = "xDriverClose")]
        private static extern UInt32 _xDriverClose(UInt32 CIFXHANDLE);

        [DllImport("cifx32dll.dll", EntryPoint = "xDriverGetErrorDescription")]
        private static extern UInt32 _xDriverGetErrorDescription(UInt32 lError,
                                                                    [Out, MarshalAs(UnmanagedType.LPArray)] byte[] szBuffer,
                                                                    UInt32 ulBufferLen);

        [DllImport("cifx32dll.dll", EntryPoint = "xDriverEnumBoards")]
        private static extern UInt32 _xDriverEnumBoards(UInt32 CIFXHANDLE,
                                                            UInt32 ulBoard,
                                                            UInt32 ulSize,
                                                            ref BOARD_INFORMATIONtag pvBoardInfo);

        [DllImport("cifx32dll.dll", EntryPoint = "xDriverEnumChannels")]
        private static extern UInt32 _xDriverEnumChannels(UInt32 CIFXHANDLE,
                                                            UInt32 ulBoard,
                                                            UInt32 ulChannel,
                                                            UInt32 ulSize,
                                                            ref CHANNEL_INFORMATIONtag pvChannelInfo);
        [DllImport("cifx32dll.dll", EntryPoint = "xDriverMemoryPointer")]
        private static extern UInt32 _xDriverMemoryPointer(UInt32 hDriver,
                                                            UInt32 ulBoard,
                                                            UInt32 ulCmd,
                                                            ref MEMORY_INFORMATION pvMemoryInfo);

        [DllImport("cifx32dll.dll", EntryPoint = "xDriverRestartDevice")]
        private static extern UInt32 _xDriverRestartDevice(UInt32 hDriver,
                                                            string szBoardName,
                                                            string pvData);

        [DllImport("cifx32dll.dll", EntryPoint = "xSysdeviceOpen")]
        private static extern UInt32 _xSysdeviceOpen(UInt32 hDriver,
                                                        string szBoard,
                                                        [MarshalAs(UnmanagedType.U4)] ref UInt32 phSysdevice);

        [DllImport("cifx32dll.dll", EntryPoint = "xSysdeviceClose")]
        private static extern UInt32 _xSysdeviceClose(UInt32 hSysdevice);

        [DllImport("cifx32dll.dll", EntryPoint = "xSysdeviceGetMBXState")]
        private static extern UInt32 _xSysdeviceGetMBXState(UInt32 hSysdevice,
                                                      ref UInt32 pulRecvPktCount,
                                                      ref UInt32 pulSendPktCount);

        [DllImport("cifx32dll.dll", EntryPoint = "xSysdevicePutPacket")]
        private static extern UInt32 _xSysdevicePutPacket(UInt32 hSysdevice,
                                                           ref CIFX_PACKETtag ptSendPkt,
                                                           UInt32 ulTimeout);

        [DllImport("cifx32dll.dll", EntryPoint = "xSysdeviceGetPacket")]
        private static extern UInt32 _xSysdeviceGetPacket(UInt32 hSysdevice,
                                                          UInt32 ulSize,
                                                          ref CIFX_PACKETtag ptRecvPkt,
                                                          UInt32 ulTimeout);

        [DllImport("cifx32dll.dll", EntryPoint = "xSysdeviceInfo")]
        private static extern UInt32 _xSysdeviceInfo(UInt32 hSysdevice,
                                                      UInt32 ulCmd,
                                                      UInt32 ulSize,
                                                      [Out, MarshalAs(UnmanagedType.LPArray)] byte[] pvzData);

        [DllImport("cifx32dll.dll", EntryPoint = "xSysdeviceFindFirstFile")]
        private static extern UInt32 _xSysdeviceFindFirstFile(UInt32 hSysdevice,
                                                        UInt32 ulChannel,
                                                        ref CIFX_DIRECTORYENTRYtag ptDirectoryInfo,
                                                        string PFN1,
                                                        ref int pvUser);

        [DllImport("cifx32dll.dll", EntryPoint = "xSysdeviceFindNextFile")]
        private static extern UInt32 _xSysdeviceFindNextFile(UInt32 hSysdevice,
                                                              UInt32 ulChannel,
                                                              ref CIFX_DIRECTORYENTRYtag ptDirectoryInfo,
                                                              string PFN1,
                                                              ref int pvUser);

        [DllImport("cifx32dll.dll", EntryPoint = "xSysdeviceDownload")]
        private static extern UInt32 _xSysdeviceDownload(UInt32 hSysdevice,
                                                            UInt32 ulChannel,
                                                            UInt32 ulMode,
                                                           [MarshalAs(UnmanagedType.LPStr)] string pszFileName,
                                                            byte[] pabFileData,
                                                            UInt32 ulFileSize,
                                                            string PFN1,
                                                            string PFN2,
                                                            UInt32 pvUser);

        [DllImport("cifx32dll.dll", EntryPoint = "xSysdeviceUpload")]
        private static extern UInt32 _xSysdeviceUpload(UInt32 hSysdevice,
                                                            UInt32 ulChannel,
                                                            UInt32 ulMode,
                                                           [MarshalAs(UnmanagedType.LPStr)] string pszFileName,
                                                            Byte[] pabFileData,
                                                            UInt32 pulFileSize,
                                                            string PFN1,
                                                            string PFN2,
                                                            ref UInt32 pvUser);

        [DllImport("cifx32dll.dll", EntryPoint = "xSysdeviceReset")]
        private static extern UInt32 _xSysdeviceReset(UInt32 hSysdevice, UInt32 ulTimeout);

        /* Channel depending functions */
        [DllImport("cifx32dll.dll", EntryPoint = "xChannelOpen")]
        private static extern UInt32 _xChannelOpen(UInt32 CIFXHANDLE,
                                                           [MarshalAs(UnmanagedType.LPStr)] string szBoard,
                                                            UInt32 ulChannel,
                                                           [MarshalAs(UnmanagedType.U4)]ref UInt32 phChannel);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelClose")]
        private static extern UInt32 _xChannelClose(UInt32 hChannel);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelFindFirstFile")]
        private static extern UInt32 _xChannelFindFirstFile(UInt32 hChannel,
                                                            ref CIFX_DIRECTORYENTRYtag ptDirectoryInfo,
                                                            string PFN1,
                                                            ref int pvUser);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelFindNextFile")]
        private static extern UInt32 _xChannelFindNextFile(UInt32 hChannel,
                                                            ref CIFX_DIRECTORYENTRYtag ptDirectoryInfo,
                                                            string PFN1,
                                                            ref int pvUser);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelDownload")]
        private static extern UInt32 _xChannelDownload(UInt32 hChannel,
                                                            UInt32 ulMode,
                                                            [MarshalAs(UnmanagedType.LPStr)] string sFileName,
                                                            Byte[] pabFileData,
                                                            UInt32 ulFileSize,
                                                            string PFN1,
                                                            string PFN2,
                                                            UInt32 pvUser);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelUpload")]
        private static extern UInt32 _xChannelUpload(UInt32 hChannel,
                                                            UInt32 ulMode,
                                                           [MarshalAs(UnmanagedType.LPStr)] string pszFileName,
                                                           [In, MarshalAs(UnmanagedType.LPArray)] byte[] pabFileData,
                                                            ref UInt32 pulFileSize,
                                                            string PFN1,
                                                            string PFN2,
                                                            UInt32 pvUser);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelGetMBXState")]
        private static extern UInt32 _xChannelGetMBXState(UInt32 hChannel,
                                                           ref UInt32 pulRecvPktCount,
                                                           ref UInt32 pulSendPktCount);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelPutPacket")]
        private static extern UInt32 _xChannelPutPacket(UInt32 hChannel,
                                                           ref CIFX_PACKETtag ptSendPkt,
                                                           UInt32 ulTimeout);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelGetPacket")]
        private static extern UInt32 _xChannelGetPacket(UInt32 hChannel,
                                                           UInt32 ulSize,
                                                           ref CIFX_PACKETtag ptRecvPkt,
                                                           UInt32 ulTimeout);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelGetSendPacket")]
        private static extern UInt32 _xChannelGetSendPacket(UInt32 hChannel,
                                                            UInt32 ulSize,
                                                            ref CIFX_PACKETtag ptRecvPkt);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelConfigLock")]
        private static extern UInt32 _xChannelConfigLock(UInt32 hChannel,
                                                          UInt32 ulCmd,
                                                          ref int pulState,
                                                          UInt32 ulTimeout);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelReset")]
        private static extern UInt32 _xChannelReset(UInt32 hChannel,
                                                        UInt32 ulResetMode,
                                                        UInt32 ulTimeout);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelInfo")]
        private static extern UInt32 _xChannelInfo(UInt32 CHANNELHANDLE,
                                                    UInt32 ulSize,
                                                    ref CHANNEL_INFORMATIONtag pvChannelInfo);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelWatchdog")]
        private static extern UInt32 _xChannelWatchdog(UInt32 hChannel,
                                                        UInt32 ulCmd,
                                                        ref int pulTrigger);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelHostState")]
        private static extern UInt32 _xChannelHostState(UInt32 hChannel,
                                                    UInt32 ulCmd,
                                                    ref int pulState,
                                                    int ulTimeout);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelBusState")]
        private static extern UInt32 _xChannelBusState(UInt32 hChannel,
                                                        UInt32 ulCmd,
                                                        ref int pulState,
                                                        int ulTimeout);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelIOInfo")]
        private static extern UInt32 _xChannelIOInfo(UInt32 hChannel,
                                                      UInt32 ulCmd,
                                                      UInt32 ulAreaNumber,
                                                      UInt32 ulSize,
                                                      ref CHANNEL_IO_INFORMATIONtag pvData);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelIORead")]
        private static extern UInt32 _xChannelIORead(UInt32 hChannel,
                                               UInt32 ulAreaNumber,
                                               UInt32 ulOffset,
                                               UInt32 ulDataLen,
                                               [In, MarshalAs(UnmanagedType.LPArray)] byte[] pvData,
                                               UInt32 ulTimeout);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelIOWrite")]
        private static extern UInt32 _xChannelIOWrite(UInt32 hChannel,
                                                UInt32 ulAreaNumber,
                                                UInt32 ulOffset,
                                                UInt32 ulDataLen,
                                                [Out, MarshalAs(UnmanagedType.LPArray)] byte[] pvData,
                                                UInt32 ulTimeout);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelIOReadSendData")]
        private static extern UInt32 _xChannelIOReadSendData(UInt32 hChannel,
                                                      UInt32 ulAreaNumber,
                                                      UInt32 ulOffset,
                                                      UInt32 ulDataLen,
                                                      [MarshalAs(UnmanagedType.LPStr)]string pvData);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelControlBlock")]
        private static extern UInt32 _xChannelControlBlock(UInt32 hChannel,
                                                    UInt32 ulCmd,
                                                    UInt32 ulOffset,
                                                    UInt32 ulDataLen,
                                                    [In, MarshalAs(UnmanagedType.LPArray)] byte[] pvData);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelCommonStatusBlock")]
        private static extern UInt32 _xChannelCommonStatusBlock(UInt32 hChannel,
                                                         UInt32 ulCmd,
                                                         UInt32 ulOffset,
                                                         UInt32 ulDataLen,
                                                         [In, MarshalAs(UnmanagedType.LPArray)] byte[] pvData);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelExtendedStatusBlock")]
        private static extern UInt32 _xChannelExtendedStatusBlock(UInt32 hChannel,
                                                           UInt32 ulCmd,
                                                           UInt32 ulOffset,
                                                           UInt32 ulDataLen,
                                                           [In, MarshalAs(UnmanagedType.LPArray)] byte[] pvData);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelUserBlock")]
        private static extern UInt32 _xChannelUserBlock(UInt32 hChannel,
                                                 UInt32 ulAreaNumber,
                                                 UInt32 ulCmd,
                                                 UInt32 ulOffset,
                                                 UInt32 ulDataLen,
                                                 [In, MarshalAs(UnmanagedType.LPArray)] byte[] pvData);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelPLCMemoryPtr")]
        private static extern UInt32 _xChannelPLCMemoryPtr(UInt32 hChannel,
                                                    UInt32 ulCmd,
                                                    ref MEMORY_INFORMATION pvMemoryInfo);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelPLCIsReadReady")]
        private static extern UInt32 _xChannelPLCIsReadReady(UInt32 hChannel,
                                                      UInt32 ulAreaNumber,
                                                      ref UInt32 pulReadState);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelPLCIsWriteReady")]
        private static extern UInt32 _xChannelPLCIsWriteReady(UInt32 hChannel,
                                                       UInt32 ulAreaNumber,
                                                       ref UInt32 pulWriteState);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelPLCActivateWrite")]
        private static extern UInt32 _xChannelPLCActivateWrite(UInt32 hChannel,
                                                        UInt32 ulAreaNumber);

        [DllImport("cifx32dll.dll", EntryPoint = "xChannelPLCActivateRead")]
        private static extern UInt32 _xChannelPLCActivateRead(UInt32 hChannel,
                                                       UInt32 ulAreaNumber);

        #endregion

        #region private constants
        ///<exclude/>
        public const int CIFX_NO_ERROR = 0;
        ///<exclude/>
        public const int CIFX_MAX_NUMBER_OF_CHANNEL_DEFINITION = 8;
        ///<exclude/>
        public const int CIFx_MAX_INFO_NAME_LENTH = 16;
        ///<exclude/>
        public const int CIFX_SYSTEM_CHANNEL_DEFAULT_INFO_BLOCK_SIZE = 16;
        ///<exclude/>
        public const int CIFX_PACKET_HEADER_SIZE = 40;                                               /*!< Maximum size of the RCX packet header in bytes */
        ///<exclude/>
        public const int CIFX_MAX_DATA_SIZE = CIFX_MAX_PACKET_SIZE - CIFX_PACKET_HEADER_SIZE;   /*!< Maximum RCX packet data size */
        ///<exclude/>
        public const int CIFX_MAX_PACKET_SIZE = 1600;
        ///<exclude/>
        public const int CIFX_MAX_NUMBER_OF_CHANNELS = 6;
        ///<exclude/>
        public const UInt32 CIFX_NO_CHANNEL = 0xFFFFFFFF;
        ///<exclude/>
        public const int CIFX_INFO_CMD_SYSTEM_INFORMATION = 1;
        ///<exclude/>
        public const int CIFX_INFO_CMD_SYSTEM_INFO_BLOCK = 2;
        ///<exclude/>
        public const int CIFX_INFO_CMD_SYSTEM_CHANNEL_BLOCK = 3;
        ///<exclude/>
        public const int CIFX_INFO_CMD_SYSTEM_CONTROL_BLOCK = 4;
        ///<exclude/>
        public const int CIFX_INFO_CMD_SYSTEM_STATUS_BLOCK = 5;

        public const int DOWNLOAD_MODE_FIRMWARE    = 1;
        public const int DOWNLOAD_MODE_CONFIG      = 2;
        public const int DOWNLOAD_MODE_FILE        = 3;
        public const int DOWNLOAD_MODE_BOOTLOADER  = 4; /*!< Download bootloader update to target. */
        public const int DOWNLOAD_MODE_LICENSECODE = 5; /*!< License update code.                  */
        public const int DOWNLOAD_MODE_MODULE      = 6;

        public const int CIFX_SYSTEMSTART          = 1;
        public const int CIFX_CHANNELINIT          = 2;

        #endregion

        #region global definitions
        ///<exclude/>        
        public int CifxMaxPacketSize = CIFX_MAX_DATA_SIZE;                                             /*!< Maximum size of the RCX packet in bytes */

        #endregion

        #region driver specific functions
        ///<exclude/>
        public static UInt32 xDriverOpen(ref UInt32 hDriver)
        {
            return _xDriverOpen(ref hDriver);
        }
        ///<exclude/>
        public static UInt32 xDriverGetInformation(UInt32 hDriver, UInt32 size, ref DRIVER_INFORMATIONtag DriverInformation)
        {
                return _xDriverGetInformation(hDriver, size, ref DriverInformation);
        }
        ///<exclude/>
        public static UInt32 xDriverEnumBoards(UInt32 hDriver, UInt32 BoardNumber, UInt32 size, ref BOARD_INFORMATIONtag BoardInformation)
        {
                return _xDriverEnumBoards( hDriver,
                                           BoardNumber,
                                           size,
                                           ref BoardInformation);
        }
        ///<exclude/>
        public static UInt32 xDriverEnumChannels(UInt32 hDriver, UInt32 BoardNumber, UInt32 ChannelNumber, UInt32 size, ref CHANNEL_INFORMATIONtag ChannelInformation)
        {
                return _xDriverEnumChannels( hDriver,
                                             BoardNumber,
                                             ChannelNumber,
                                             size,
                                             ref ChannelInformation);
        }
        ///<exclude/>
        public static UInt32 xDriverClose(UInt32 hDriver)
        {
                return _xDriverClose(hDriver);
        }
        ///<exclude/>
        public static UInt32 xDriverGetErrorDescription(UInt32 ErrorNumber, ref byte[] szBuffer, UInt32 size)
        {
                return _xDriverGetErrorDescription(ErrorNumber, szBuffer, size);
        }
        ///<exclude/>
        public static UInt32 xDriverRestartDevice(UInt32 hDriver, string BoardName)
        {
                return _xDriverRestartDevice(hDriver, BoardName, null);
        }

        #endregion

        #region Sysdevice specific functions
        ///<exclude/>
        public static UInt32 xSysdeviceOpen(UInt32 hDriver, string BoardName, ref UInt32 hSysDevice)
        {
                return _xSysdeviceOpen(hDriver, BoardName, ref hSysDevice);
        }
        ///<exclude/>
        public static UInt32 xSysdeviceClose(UInt32 hSysDevice)
        {
                return _xSysdeviceClose(hSysDevice);
        }
        ///<exclude/>
        public static UInt32 xSysdeviceReset(UInt32 hSysDevice, UInt32 Timeout)
        {
                return _xSysdeviceReset(hSysDevice, Timeout);
        }
        ///<exclude/>
        //public int GetChannelBlock( UInt32 hSysDevice, ref byte[] ChannelNumber, ref string[] ChannelType, ref byte[] NumberOfBlocks,
        //                             ref int[] SizeOfChannel, ref int[] MbxStartOffset, ref int[] MbxSize,
        //                             ref byte[] HskWidth, ref byte[] HskPos)
        //{
        //    UInt32 ulSize = (UInt32)CIFX_MAX_NUMBER_OF_CHANNEL_DEFINITION * CIFX_SYSTEM_CHANNEL_DEFAULT_INFO_BLOCK_SIZE;

        //    byte[] abData = new byte[ulSize];

        //    _xSysdeviceInfo( hSysDevice, (UInt32)CIFX_INFO_CMD_SYSTEM_CHANNEL_BLOCK, ulSize, abData);

        //    int iIndex = 0;
        //    for (int iChannelDefinition = 0; iChannelDefinition <= CIFX_MAX_NUMBER_OF_CHANNEL_DEFINITION - 1; iChannelDefinition++)
        //    {
        //        for (int iDefaultInfoBlockSize = 0; iDefaultInfoBlockSize <= CIFX_SYSTEM_CHANNEL_DEFAULT_INFO_BLOCK_SIZE - 1; iDefaultInfoBlockSize++)
        //        {
        //            abInfoBlock[iChannelDefinition, iDefaultInfoBlockSize] = abData[iIndex];
        //            iIndex++;
        //        }
        //    }

        //    for (int iChannelDefinition = 0; iChannelDefinition <= CIFX_MAX_NUMBER_OF_CHANNEL_DEFINITION - 1; iChannelDefinition++)
        //    {
        //        byte[] ChannelSize = new byte[4] { abInfoBlock[iChannelDefinition, 4],
        //                                            abInfoBlock[iChannelDefinition, 5],
        //                                            abInfoBlock[iChannelDefinition, 6],
        //                                            abInfoBlock[iChannelDefinition, 7]};

        //        byte[] MailboxOffset = new byte[2] { abInfoBlock[iChannelDefinition, 10],
        //                                            abInfoBlock[iChannelDefinition, 11]};

        //        byte[] MailboxSize = new byte[2] { abInfoBlock[iChannelDefinition, 8],
        //                                            abInfoBlock[iChannelDefinition, 9]};

        //        ChannelNumber[iChannelDefinition] = (byte)iChannelDefinition;
        //        ChannelType[iChannelDefinition] = GetChannelType(abInfoBlock[iChannelDefinition, 0]);
        //        NumberOfBlocks[iChannelDefinition] = abInfoBlock[iChannelDefinition, 3];
        //        SizeOfChannel[iChannelDefinition] = BitConverter.ToInt32(ChannelSize, 0);
        //        MbxStartOffset[iChannelDefinition] = BitConverter.ToInt16(MailboxOffset, 0);
        //        MbxSize[iChannelDefinition] = BitConverter.ToInt16(MailboxSize, 0);
        //        HskWidth[iChannelDefinition] = abInfoBlock[iChannelDefinition, 2];
        //        HskPos[iChannelDefinition] = abInfoBlock[iChannelDefinition, 2];
        //    }
        //    return (int)lReturn;
        //}
        ///<exclude/>        
        private static string GetChannelType(byte bCHType)
        {
            switch (bCHType)
            {
                case 0x00:
                    return "UNDEFINED";
                case 0x01:
                    return "NOT AVAILABLE";
                case 0x02:
                    return "RESERVED";
                case 0x03:
                    return "SYSTEM";
                case 0x04:
                    return "HANDSHAKE";
                case 0x05:
                    return "COMMUNICATION";
                case 0x06:
                    return "APPLICATION";
            }
            return "RESERVED";
        }
        ///<exclude/>
        //public int xSysdeviceInfo(UInt32 hSysDevice, int Command)
        //{
        //    UInt32 ulSize = 0;

        //    switch (Command)
        //    {
        //        case CIFX_INFO_CMD_SYSTEM_INFORMATION:
        //            ulSize = (UInt32)Marshal.SizeOf(SYSTEM_CHANNEL_INFORMATIONtag);
        //            break;

        //        case CIFX_INFO_CMD_SYSTEM_INFO_BLOCK:
        //            ulSize = (UInt32)Marshal.SizeOf(SYSTEM_CHANNEL_INFO_BLOCKtag);
        //            break;

        //        //case CIFX_INFO_CMD_SYSTEM_CHANNEL_BLOCK:
        //        //    ulSize = (UInt32)CIFX_MAX_NUMBER_OF_CHANNEL_DEFINITION * CIFX_SYSTEM_CHANNEL_DEFAULT_INFO_BLOCK_SIZE;
        //        //    break;

        //        case CIFX_INFO_CMD_SYSTEM_CONTROL_BLOCK:
        //            ulSize = (UInt32)Marshal.SizeOf(SYSTEM_CHANNEL_SYSTEM_CONTROL_BLOCKtag);
        //            break;

        //        case CIFX_INFO_CMD_SYSTEM_STATUS_BLOCK:
        //            ulSize = sizeof SYSTEM_CHANNEL_SYSTEM_STATUS_BLOCKtag;
        //            break;
        //    }
        //    try
        //    {
        //        byte[] abData = new byte[ulSize];

        //        UInt32 lReturn = _xSysdeviceInfo(hSysDevice, (UInt32)Command, ulSize, abData);

        //        IntPtr pData = Marshal.AllocHGlobal(abData.Length);
        //        GCHandle pinnedData = GCHandle.Alloc(abData, GCHandleType.Pinned);

        //        switch (Command)
        //        {
        //            case CIFX_INFO_CMD_SYSTEM_INFORMATION:
        //                _SystemChannelInformation = (APIStruct.SYSTEM_CHANNEL_INFORMATIONtag)Marshal.PtrToStructure(
        //                                             pinnedData.AddrOfPinnedObject(), typeof(APIStruct.SYSTEM_CHANNEL_INFORMATIONtag));
        //                pinnedData.Free();

        //                break;

        //            case CIFX_INFO_CMD_SYSTEM_INFO_BLOCK:
        //                _SystemChannelInfoBlock = (APIStruct.SYSTEM_CHANNEL_INFO_BLOCKtag)Marshal.PtrToStructure(
        //                                             pinnedData.AddrOfPinnedObject(), typeof(APIStruct.SYSTEM_CHANNEL_INFO_BLOCKtag));
        //                pinnedData.Free();
        //                break;

        //            case CIFX_INFO_CMD_SYSTEM_CONTROL_BLOCK:
        //                _SystemChannelSystemControlBlock = (APIStruct.SYSTEM_CHANNEL_SYSTEM_CONTROL_BLOCKtag)Marshal.PtrToStructure(
        //                                             pinnedData.AddrOfPinnedObject(), typeof(APIStruct.SYSTEM_CHANNEL_SYSTEM_CONTROL_BLOCKtag));
        //                pinnedData.Free();
        //                break;

        //            case CIFX_INFO_CMD_SYSTEM_STATUS_BLOCK:
        //                _SystemChannelSystemStatusBlock = (APIStruct.SYSTEM_CHANNEL_SYSTEM_STATUS_BLOCKtag)Marshal.PtrToStructure(
        //                                                                pinnedData.AddrOfPinnedObject(), typeof(APIStruct.SYSTEM_CHANNEL_SYSTEM_STATUS_BLOCKtag));
        //                pinnedData.Free();
        //                break;

        //        }
        //        return (int)lReturn;
        //    }
        //    catch (Exception ex)
        //    {
        //        _ErrorDescription = ex.Message.ToString();
        //        return 99;
        //    }
        //}
        ///<exclude/>
        public static UInt32 xSysdeviceDownload(UInt32 hSysDevice, UInt32 ulChannel, UInt32 Mode, string FileName, ref byte[] abFileData)
        {
            return _xSysdeviceDownload( hSysDevice, ulChannel, Mode, FileName, abFileData, (UInt32)abFileData.Length,
                                            null, null,  0);
        }
        ///<exclude/>
        public static UInt32 xSysdeviceFindFirstFile(UInt32 hSysDevice, UInt32 ChannelNumber, ref CIFX_DIRECTORYENTRYtag CifXDirectoryEntry)
        {
            int UserParam = 0;
            return _xSysdeviceFindFirstFile(hSysDevice, ChannelNumber, ref CifXDirectoryEntry, null, ref UserParam);
        }
        ///<exclude/>
        public static UInt32 xSysdeviceFindNextFile(UInt32 hSysDevice, UInt32 ChannelNumber, ref CIFX_DIRECTORYENTRYtag CifXDirectoryEntry)
        {
                int UserParam = 0;
                return _xSysdeviceFindNextFile(hSysDevice, ChannelNumber, ref CifXDirectoryEntry, null, ref UserParam);
        }
        ///<exclude/>
        public static UInt32 xSysdeviceGetMBXState(UInt32 hSysDevice, ref UInt32 RcvPktCnt, ref UInt32 SndPktCnt)
        {
                return _xSysdeviceGetMBXState(hSysDevice, ref RcvPktCnt, ref SndPktCnt);
        }
        ///<exclude/>
        public static UInt32 xSysdevicePutPacket(UInt32 hSysDevice, ref CIFX_PACKETtag tPacket, UInt32 Timeout)
        {
                return _xSysdevicePutPacket(hSysDevice, ref tPacket, Timeout);
        }
        ///<exclude/>
        public static UInt32 xSysdeviceGetPacket(UInt32 hSysDevice, UInt32 size, ref CIFX_PACKETtag tPacket, UInt32 Timeout)
        {
                return _xSysdeviceGetPacket(hSysDevice, size , ref tPacket, Timeout);
        }

        #endregion

        #region channel specific functions
        ///<exclude/>
        public static UInt32 xChannelInfo(UInt32 hChannel, UInt32 size, ref CHANNEL_INFORMATIONtag ChannelInformation)
        {
                return _xChannelInfo( hChannel,
                                      size,
                                      ref ChannelInformation);
        }
        ///<exclude/>
        public static UInt32 xChannelOpen(UInt32 hDriver, string BoardName, UInt32 ChannelNumber, ref UInt32 hChannel)
        {
                return _xChannelOpen( hDriver,
                                      BoardName,
                                      ChannelNumber,
                                      ref hChannel);
        }
        ///<exclude/>
        public static UInt32 xChannelClose(UInt32 hChannel)
        {
                return _xChannelClose(hChannel);
        }
        ///<exclude/>
        public static UInt32 xChannelReset(UInt32 hChannel, UInt32 Command, UInt32 Timeout)
        {
                return _xChannelReset(hChannel, Command, Timeout);
        }
        ///<exclude/>
        public static UInt32 xChannelDownload(UInt32 hChannel, UInt32 Mode, string FileName, ref byte[] abFileData)
        {
                return _xChannelDownload( hChannel,
                                          Mode,
                                          FileName,
                                          abFileData,
                                          (UInt32)abFileData.Length,
                                          null,
                                          null,
                                          0);
        }
        ///<exclude/>
        public static UInt32 xChannelUpload(UInt32 hChannel, UInt32 Mode, string FileName, UInt32 FileSize, ref byte[] abFileData)
        {
                return _xChannelUpload(hChannel, Mode, FileName, abFileData, ref FileSize, null, null, 0);
        }
        ///<exclude/>
        ///<exclude/>
        public static UInt32 xChannelGetMBXState(UInt32 hChannel, ref UInt32 RcvPktCnt, ref UInt32 SndPktCnt)
        {
                return _xChannelGetMBXState(hChannel, ref RcvPktCnt, ref SndPktCnt);
        }
        ///<exclude/>
        public static UInt32 xChannelHostState(UInt32 hChannel, UInt32 Command, ref int pulState, int Timeout)
        {
                return _xChannelHostState(hChannel, Command , ref pulState, Timeout);
        }
        ///<exclude/>
        public static UInt32 xChannelBusState(UInt32 hChannel, UInt32 Command, ref int pulState, int ulTimeout)
        {
                return _xChannelBusState(hChannel, Command, ref pulState, ulTimeout);
        }
        ///<exclude/>
        public static UInt32 xChannelConfigLock(UInt32 hChannel, UInt32 Command, ref int pulState, UInt32 Timeout)
        {
                return _xChannelConfigLock(hChannel, Command, ref pulState, Timeout);
        }
        ///<exclude/>
        public static UInt32 xChannelWatchdog(UInt32 hChannel, UInt32 Command, ref int pulTrigger)
        {
                return _xChannelWatchdog(hChannel, Command, ref pulTrigger);
        }
        ///<exclude/>
        public static UInt32 xChannelFindFirstFile(UInt32 hChannel, ref CIFX_DIRECTORYENTRYtag CifXDirectoryEntry)
        {
                int UserParam = 0;
                return _xChannelFindFirstFile(hChannel, ref CifXDirectoryEntry, null, ref UserParam);
        }
        ///<exclude/>
        public static UInt32 xChannelFindNextFile(UInt32 hChannel, ref CIFX_DIRECTORYENTRYtag CifXDirectoryEntry)
        {
                int UserParam = 0;
                return _xChannelFindNextFile(hChannel, ref CifXDirectoryEntry, null, ref UserParam);
        }
        ///<exclude/>
        public static UInt32 xChannelIORead(UInt32 hChannel, UInt32 AreaNumber, UInt32 Offset, UInt32 DataLen, ref byte[] pvData, UInt32 Timeout)
        {
                return _xChannelIORead(hChannel, AreaNumber, Offset, DataLen, pvData, Timeout);
        }
        ///<exclude/>
        public static UInt32 xChannelIOWrite(UInt32 hChannel, UInt32 AreaNumber, UInt32 Offset, UInt32 DataLen, ref byte[] pvData, UInt32 Timeout)
        {
                return _xChannelIOWrite(hChannel, AreaNumber, Offset, DataLen, pvData, Timeout);
        }
        ///<exclude/>
        public static UInt32 xChannelIOInfo(UInt32 hChannel, UInt32 Command, UInt32 AreaNumber, UInt32 size, ref CHANNEL_IO_INFORMATIONtag ChannelIOInformation)
        {
                return _xChannelIOInfo(hChannel, Command, AreaNumber, size, ref ChannelIOInformation);
        }
        ///<exclude/>
        public static UInt32 xChannelPutPacket(UInt32 hChannel, ref CIFX_PACKETtag tPacket, UInt32 Timeout)
        {
                return _xChannelPutPacket(hChannel, ref tPacket, Timeout);
        }
        ///<exclude/>
        public static UInt32 xChannelGetPacket(UInt32 hChannel, ref CIFX_PACKETtag tPacket, UInt32 Timeout)
        {
                return _xChannelGetPacket(hChannel, (UInt32)Marshal.SizeOf(tPacket), ref tPacket, Timeout);
        }
        ///<exclude/>
        public static UInt32 xChannelControlBlock(UInt32 hChannel, ref byte[] DataBuffer, UInt32 Command, UInt32 Offset, UInt32 DataLen)
        {
                return _xChannelControlBlock(hChannel, Command, Offset, DataLen, DataBuffer);
        }
        ///<exclude/>
        public static UInt32 xChannelCommonStatusBlock(UInt32 hChannel, ref byte[] DataBuffer, UInt32 Command, UInt32 Offset, UInt32 DataLen)
        {
                return _xChannelCommonStatusBlock(hChannel, Command, Offset, DataLen, DataBuffer);
        }
        ///<exclude/>
        public static UInt32 xChannelExtendedStatusBlock(UInt32 hChannel, ref byte[] DataBuffer, UInt32 Command, UInt32 Offset, UInt32 DataLen)
        {
                return _xChannelExtendedStatusBlock(hChannel, Command, Offset, DataLen, DataBuffer);
        }

        #endregion
    }
}
